
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"

using namespace std;


// generates polynomial roots
int main (int argc, char * const argv[])
{
    poly        x;
    int         i, len, n, decPrec;
    string      inString;
    char        *xString;
    fpComplex   *root, *Parray;
    bool        doRoundToZero=true;
    
again:
    decPrec = 0;
    while(decPrec<16)
    {
        cout << "decPrec: ";
        cin >> decPrec;
    }
    setBlockPrec(decPrec/8 + 1);
    
    cin.ignore();  // needed for next cin with prompt to behave
    
    cout << "poly: ";
    getline(cin, inString);
    cout << endl;
    
    len = strlen(inString.c_str());
    xString = (char*)malloc((len+1)*sizeof(char));
    strcpy(xString, inString.c_str());
    
    if(!polyConvFromxString(x, xString))
    {
        cout << "bad input" << endl << endl;
        goto again;
    }
    
    free(xString);

    n = x.deg;
    
    if(!(findPolyRoots(root, Parray, x, doRoundToZero)))
    {
        cout << "failed" << endl;
        goto again;
    }
    cout << "roots:" << endl;
    for(i=0;i<n;++i)
        cout << root[i] << endl;
    
    cout << "Parray:" << endl;
    for(i=0;i<n;++i)
        cout << Parray[i] << endl;
    
    cout << endl;
    goto again;
    
    return 0;
}

